# 최댓값

숫자로 구성된 리스트의 최댓값을 찾는다.

## 활용

리스트의 최댓값을 찾으면, 다음과 같은 작업들을 수행할 수 있다.

- 가장 큰 값을 기준으로 레코드 정렬하기
- 특정 항목을 탐색하는 시간 줄이기

## 방법

최댓값은 다양한 방식으로 찾을 수 있다. 여기서는 세 가지 방법을 제시한다.

1. 리스트의 모든 원소를 비교한다.
2. 이미 정의된 함수를 사용한다.
3. 정렬한다.

## 예시 1

리스트의 모든 원소를 비교한다:

`[6, 4, 50, 8, 70, 2, 20]`라는 리스트가 주어졌을 때, 이 리스트의 최댓값을 구하라.

### 1단계

`[6, 4, 50, 8, 70, 2, 20]`를 함수에 입력한다.

### 2단계

비교 과정을 통해 가장 큰 숫자를 찾을 것이다. 리스트의 첫 원소를 최댓값으로 설정한다.

`max = array[0]`이므로, `max = 6`이다.

### 3단계

리스트의 모든 원소와 최댓값을 비교한다. 만약 원소가 최댓값보다 크면, 그 수를 최댓값으로 지정한다.

`max`와 `array[2]`를 비교하면 `6 < 50`이므로, `max = 50`이 된다.

모든 원소와 비교가 끝나면, `max = 70`이다.

### 4단계

`70`을 반환한다.

## 예시 2

이미 정의된 함수를 사용한다:

`[6, 4, 50, 8, 70, 2, 20]`라는 리스트가 주어졌을 때, 이 리스트의 최댓값을 구하라.

### 1단계

`[6, 4, 50, 8, 70, 2, 20]`를 함수에 입력한다.

### 2단계

이미 정의된 `max` 함수가 `70`을 반환한다.

### 3단계

`70`을 반환한다.

## 예시 3

정렬한다:

`[6, 4, 50, 8, 70, 2, 20]`라는 리스트가 주어졌을 때, 이 리스트의 최댓값을 구하라.

### 1단계

`[6, 4, 50, 8, 70, 2, 20]`를 함수에 입력한다.

### 2단계

이미 정의된 `sort` 함수가 전체 리스트를 오름차순으로 정렬하여 `[2, 4, 6, 8, 20, 50, 70]`을 반환한다.

### 3단계

이미 정의된 `last` 함수가 리스트의 마지막 원소로 `70`을 반환한다.

### 4단계

`70`을 반환한다.

## 구현

- [Ruby](https://github.com/TheAlgorithms/Ruby/blob/master/maths/find_max.rb)

## 영상 URL

- [GeeksforGeeks](https://youtu.be/En68ipRaFOU)

## 출처

- [GeeksforGeeks](https://www.geeksforgeeks.org/c-program-find-largest-element-array/)
